/*
 * PSP Software Development Kit - http://www.pspdev.org
 * -----------------------------------------------------------------------
 * Licensed under the BSD license, see LICENSE in PSPSDK root for details.
 *
 */
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspdisplay.h>
#include <pspsdk.h>

#include "nmeap.h"
#define printf pspDebugScreenPrintf
PSP_MODULE_INFO("GPSCOMM", 0x1000, 1, 1);
PSP_MAIN_THREAD_ATTR(0);


nmeap_gga_t g_gga;

double        ggalatitude;
double        ggalongitude;
double        altitude;
unsigned long time;
int           satellites;
int           quality;
double        hdop;
double        geoid;
char          warn;

double        latitude;
double        longitude;
double        speed;
double        course;
unsigned long date;
double        magvar;
char buffer[512]; 



void print_data() {
	pspDebugScreenClear();
	printf("\n\t\t\t\t === GPSlim236 VIEWER ===\n\n");
	printf("--------------------------------------------------------------------\n");
	printf("\tLATITUDE:        %10.6f",latitude);
	printf("\tGGA Lat:       %10.6f\n",latitude);
	printf("\tLONGITUDE:       %10.6f",longitude);
	printf("\tGGA Lon:       %10.6f\n",longitude);
	printf("\tALTITUDE:        %.2f\n", altitude);
	printf("\tSPEED:           %.2f\n",speed);
	printf("\tCOURSE:          %10.6f\n",course);
	printf("\tSATELLITES:      %02d   ", satellites);
	printf("\t\tData Status:   %c\n",warn);
	printf("\tSIGNAL QUALITY:  %02d   ",quality);
	printf("\t\tHDOP:          %10.6f\n",hdop);
	printf("\tTIME:            %02d:%02d:%02d  ", time/10000,time%10000/100,time%100);
	printf("\tMag variation: %10.6f\n",magvar);
	printf("\tDATE:            %02d/%02d/%02d  ", date/10000, date%10000/100,date%100);
	printf("\tGeoid:         %10.6f\n",geoid);
	printf("--------------------------------------------------------------------\n\n");
	printf("==================== MOST RECENT NMEA SENTENCES ====================\n");
	printf("%s", buffer);
}

/** do something with the GGA data */
static void print_gga(nmeap_gga_t *gga)
{
/*    printf("GPGGA: %.6f %.6f %.0f %lu %d %d %f %f\n",
            gga->latitude  ,
            gga->longitude, 
            gga->altitude , 
            gga->time     , 
            gga->satellites,
            gga->quality   ,
            gga->hdop      ,
            gga->geoid     
            );
*/
            ggalatitude=gga->latitude; 
            ggalongitude=gga->longitude;
            altitude=gga->altitude , 
            time=gga->time; 
            satellites=gga->satellites;
            quality=gga->quality; 
            hdop=gga->hdop;
            geoid=gga->geoid;     

		print_data(); 

}


/** called when a gpgga message is received and parsed */
static void gpgga_callout(nmeap_context_t *context,void *data,void *user_data)
{
    nmeap_gga_t *gga = (nmeap_gga_t *)data;
    print_gga(gga);
}


/** do something with the RMC data */
static void print_rmc(nmeap_rmc_t *rmc)
{
    /*printf("GPRMC: %lu %c %.6f %.6f %f %f %lu %f\n",
            rmc->time,
            rmc->warn,
            rmc->latitude,
            rmc->longitude,
            rmc->speed,
            rmc->course,
            rmc->date,
            rmc->magvar
            ); */
            time=rmc->time;
            warn=rmc->warn;
            latitude=rmc->latitude;
            longitude=rmc->longitude;
            speed=rmc->speed;
            course=rmc->course;
            date=rmc->date;
            magvar=rmc->magvar;

		print_data(); 


}

/** called when a gprmc message is received and parsed */
static void gprmc_callout(nmeap_context_t *context,void *data,void *user_data)
{
    nmeap_rmc_t *rmc = (nmeap_rmc_t *)data;
    print_rmc(rmc);
}


static nmeap_context_t nmea;	   /* parser context */
static nmeap_gga_t     gga;		   /* this is where the data from GGA messages will show up */
static nmeap_rmc_t     rmc;		   /* this is where the data from RMC messages will show up */
static int             user_data; /* user can pass in anything. typically it will be a pointer to some user data */


int main(void)
{
	pspDebugScreenInit();
	pspDebugScreenSetBackColor(0x00007700);
	pspDebugSioInit();
    	pspDebugSioSetBaud(38400);

	pspDebugScreenClear();
	pspDebugScreenPrintf("\n\n\n\t\t\tPSP GPSlim 236 VIEWER:\n\n\n");
	pspDebugScreenPrintf("\n\t\tCONNECT YOUR GPS TO SERAL PORT AND TURN IT ON \n\n\n");

	double i=0;
        int 	ch;
	int     status;



    status = nmeap_init(&nmea,(void *)&user_data);
    if (status != 0) {
        printf("nmeap_init %d\n",status);
        exit(1);
    }
    
    status = nmeap_addParser(&nmea,"GPGGA",nmeap_gpgga,gpgga_callout,&gga);
    if (status != 0) {
        printf("nmeap_add %d\n",status);
        exit(1);
    }

    status = nmeap_addParser(&nmea,"GPRMC",nmeap_gprmc,gprmc_callout,&rmc);
    if (status != 0) {
        printf("nmeap_add %d\n",status);
        exit(1);
    }


int counter=0;
int linecounter=0;
	while(i<200000000)
	{
		i++;
		sceKernelDelayThread(20);
		ch = pspDebugSioGetchar();

		if (ch>0) {
			if (ch=='\n')
				linecounter++;
			if (counter<510 || linecounter<4)
				buffer[counter++]=ch;
			else {
				memset(buffer,0,sizeof(buffer));
				counter=0;
				linecounter=0;
			}

			status = nmeap_parse(&nmea,ch);
        
        switch(status) {
        case NMEAP_GPGGA:
			/* GOT A GPGGA MESSAGE */
            print_gga(&gga);
            break;
        case NMEAP_GPRMC:
			/* GOT A GPRMC MESSAGE */
            print_rmc(&rmc);
            break;
        default:
            break;
        }

		}

	}

	sceKernelExitGame();

	return 0;
}
